/*
 * test_data.c
 *
 *  Created on: Apr 29, 2015
 *      Author: Jordan
 */

#include "sys_common.h"
#include "config.h"
#include "EKF.h"

#define TEST_LENGTH 500

float32 test_AHRS_x0[AHRS_N_STATES] = {0.971066575507096, -0.019222529748583, 0.020170015720699, 0.237177930568621, 0, 0, 0};
float32 test_INS_x0[INS_N_STATES] = {0, 0, -0.175503840000005, 0.010000000000000, 0, 0, 0, 0, 0};

float32 test_wx[TEST_LENGTH] = {0.0028,  0.0028,  0.0033,  0.0023,  0.0028,  0.0028,  0.0028,  0.0033,  0.0017,  0.0033,  0.0028,  0.0028,  0.0028,  0.0028,  0.0028,  0.0028,  0.0033,  0.0028,  0.0028,  0.0023,  0.0028,  0.0028,  0.0023,  0.0023,  0.0028,  0.0033,  0.0023,  0.0033,  0.0028,  0.0017,  0.0028,  0.0028,  0.0028,  0.0017,  0.0023,  0.0028,  0.0023,  0.0023,  0.0028,  0.0028,  0.0017,  0.0028,  0.0033,  0.0023,  0.0023,  0.0028,  0.0017,  0.0023,  0.0028,  0.0033,  0.0017,  0.0033,  0.0017,  0.0028,  0.0028,  0.0033,  0.0017,  0.0023,  0.0023,  0.0023,  0.0028,  0.0017,  0.0028,  0.0017,  0.0028,  0.0017,  0.0023,  0.0023,  0.0023,  0.0033,  0.0012,  0.0033,  0.0012,  0.0033,  0.0028,  0.0028,  0.0023,  0.0023,  0.0028,  0.0028,  0.0023,  0.0017,  0.0023,  0.0017,  0.0023,  0.0039,  0.0044,  0.0007,  0.0039,  0.0017,  0.0028,  0.0044,  0.0007,  0.0039,  0.0001,  0.0023,  0.0012,  0.0023,  0.0023,  0.0049,  0.0028,  0.0017, -0.0020, -0.0004,  0.0113, -0.0041,  0.0076,  0.0017,  0.0097,  0.0108, -0.0212, -0.0962, -0.1664, -0.2276, -0.2532, -0.2494, -0.1850, -0.0536,  0.0964,  0.2273,  0.3343,  0.4099,  0.4248,  0.3763,  0.3008,  0.2263,  0.1582,  0.0991,  0.0613,  0.0517,  0.0608,  0.0730,  0.0789,  0.0672,  0.0491,  0.0395,  0.0166, -0.0430, -0.1185, -0.1808, -0.2170, -0.2276, -0.2345, -0.2606, -0.2909, -0.3032, -0.2994, -0.2569, -0.1781, -0.1042, -0.0584, -0.0376, -0.0249, -0.0132, -0.0052, -0.0025, -0.0084, -0.0382, -0.0909, -0.1382, -0.1515, -0.1212, -0.0738, -0.0541, -0.0616, -0.0589, -0.0355, -0.0020,  0.0289,  0.0592,  0.1044,  0.1571,  0.2029,  0.2130,  0.1773,  0.1262,  0.0752,  0.0379,  0.0177,  0.0140,  0.0368,  0.0901,  0.1534,  0.1922,  0.2061,  0.2055,  0.2018,  0.1928,  0.1800,  0.1784,  0.1848,  0.1869,  0.1837,  0.1880,  0.2013,  0.2210,  0.2460,  0.2768,  0.3056,  0.3221,  0.3167,  0.2949,  0.2790,  0.2811,  0.2784,  0.2508,  0.1917,  0.1156,  0.0619,  0.0353,  0.0257,  0.0076, -0.0265, -0.0595, -0.0818, -0.0909, -0.0935, -0.0967, -0.0988, -0.0871, -0.0589, -0.0243,  0.0065,  0.0347,  0.0549,  0.0650,  0.0656,  0.0592,  0.0470,  0.0241, -0.0047, -0.0371, -0.0653, -0.0829, -0.1063, -0.1302, -0.1483, -0.1675, -0.1803, -0.1808, -0.1824, -0.1829, -0.1803, -0.1717, -0.1558, -0.1313, -0.1010, -0.0728, -0.0478, -0.0233, -0.0116, -0.0174, -0.0302, -0.0424, -0.0557, -0.0781, -0.0962, -0.1063, -0.1270, -0.1622, -0.2042, -0.2297, -0.2324, -0.2207, -0.2116, -0.2154, -0.2335, -0.2489, -0.2548, -0.2452, -0.2143, -0.1728, -0.1345, -0.1047, -0.0802, -0.0536, -0.0329, -0.0222, -0.0180, -0.0174, -0.0243, -0.0281, -0.0142,  0.0102,  0.0400,  0.0688,  0.0911,  0.1092,  0.1241,  0.1417,  0.1688,  0.2039,  0.2417,  0.2731,  0.2896,  0.2939,  0.2843,  0.2577,  0.2247,  0.2055,  0.1853,  0.1614,  0.1417,  0.1204,  0.0927,  0.0640,  0.0374,  0.0246,  0.0166,  0.0086, -0.0020, -0.0105, -0.0196, -0.0366, -0.0616, -0.0818, -0.0871, -0.0866, -0.0850, -0.0818, -0.0781, -0.0749, -0.0770, -0.0866, -0.0935, -0.0914, -0.0845, -0.0813, -0.0845, -0.0839, -0.0690, -0.0451, -0.0180,  0.0129,  0.0464,  0.0837,  0.1225,  0.1672,  0.2151,  0.2513,  0.2731,  0.2891,  0.2944,  0.2907,  0.2832,  0.2800,  0.2688,  0.2428,  0.2013,  0.1528,  0.1055,  0.0645,  0.0315,  0.0012, -0.0270, -0.0451, -0.0510, -0.0472, -0.0392, -0.0238,  0.0081,  0.0459,  0.0773,  0.1023,  0.1145,  0.1199,  0.1172,  0.1007,  0.0725,  0.0422,  0.0129, -0.0196, -0.0563, -0.0925, -0.1276, -0.1579, -0.1840, -0.1994, -0.2063, -0.2069, -0.2010, -0.1840, -0.1574, -0.1324, -0.1137, -0.0972, -0.0797, -0.0589, -0.0355, -0.0126,  0.0076,  0.0092, -0.0063, -0.0275, -0.0510, -0.0674, -0.0781, -0.0956, -0.1217, -0.1515, -0.1776, -0.1941, -0.1946, -0.1925, -0.1866, -0.1771, -0.1648, -0.1494, -0.1345, -0.1201, -0.1010, -0.0680, -0.0291, -0.0020,  0.0124,  0.0177,  0.0262,  0.0464,  0.0666,  0.0741,  0.0635,  0.0480,  0.0475,  0.0629,  0.0869,  0.1034,  0.1044,  0.0948,  0.0778,  0.0624,  0.0565,  0.0693,  0.0874,  0.1023,  0.1092,  0.1172,  0.1316,  0.1454,  0.1443,  0.1252,  0.0922,  0.0576,  0.0342,  0.0283,  0.0251,  0.0118, -0.0105, -0.0339, -0.0472, -0.0446, -0.0430, -0.0520, -0.0674, -0.0882, -0.1058, -0.1058, -0.0914, -0.0632, -0.0281,  0.0076,  0.0337,  0.0411,  0.0347,  0.0150, -0.0142, -0.0462, -0.0696, -0.0797, -0.0744, -0.0557, -0.0345, -0.0212, -0.0201, -0.0126,  0.0188,  0.0613,  0.0831,  0.0815,  0.0661,  0.0363, -0.0009, -0.0339, -0.0520, -0.0504, -0.0387, -0.0270, -0.0158,  0.0023,  0.0283,  0.0507,  0.0661,  0.0799,  0.0954,  0.1113,  0.1342,  0.1715,  0.2220,  0.2587,  0.2720,  0.2800};
float32 test_wy[TEST_LENGTH] = {-0.0004, -0.0014,  0.0002, -0.0004, -0.0009, -0.0004, -0.0004, -0.0004, -0.0009, -0.0004, -0.0004,  0.0002, -0.0009, -0.0014, -0.0004, -0.0004, -0.0014,  0.0002, -0.0004, -0.0020,  0.0002,  0.0002, -0.0009, -0.0004, -0.0014, -0.0009, -0.0014, -0.0004, -0.0004,  0.0002, -0.0014, -0.0004,  0.0002, -0.0004, -0.0009, -0.0004, -0.0020, -0.0014,  0.0002, -0.0014, -0.0014,  0.0007, -0.0004, -0.0004, -0.0009, -0.0009,  0.0002, -0.0009, -0.0009,  0.0007, -0.0014,  0.0002, -0.0004,  0.0002, -0.0014,  0.0002, -0.0009, -0.0014,  0.0002, -0.0020,  0.0007, -0.0009, -0.0004,  0.0002, -0.0004, -0.0004,  0.0002,  0.0002, -0.0004, -0.0004, -0.0014,  0.0007, -0.0014,  0.0007, -0.0009,  0.0002, -0.0009, -0.0009, -0.0004, -0.0009,  0.0007, -0.0004,  0.0007, -0.0009, -0.0014,  0.0018,  0.0023, -0.0014,  0.0002, -0.0025,  0.0002,  0.0018, -0.0020,  0.0002, -0.0036, -0.0004, -0.0004,  0.0007,  0.0007,  0.0007, -0.0014,  0.0018,  0.0007, -0.0030,  0.0081, -0.0084,  0.0028, -0.0030,  0.0060,  0.0018, -0.0318, -0.1057, -0.2175, -0.3016, -0.3314, -0.3468, -0.3452, -0.2984, -0.2372, -0.1989, -0.1712, -0.1478, -0.1472, -0.1871, -0.2313, -0.2420, -0.2228, -0.1808, -0.1281, -0.0759, -0.0227,  0.0268,  0.0624,  0.0752,  0.0731,  0.0592,  0.0161, -0.0557, -0.1254, -0.1659, -0.1728, -0.1563, -0.1425, -0.1616, -0.2026, -0.2308, -0.2223, -0.1584, -0.0722, -0.0121, -0.0009, -0.0238, -0.0467, -0.0578, -0.0690, -0.0972, -0.1451, -0.2042, -0.2446, -0.2537, -0.2356, -0.2074, -0.1850, -0.1669, -0.1425, -0.1004, -0.0483, -0.0116,  0.0012,  0.0182,  0.0848,  0.1736,  0.2423,  0.2582,  0.2178,  0.1742,  0.1683,  0.1928,  0.2295,  0.2673,  0.3109,  0.3513,  0.3721,  0.3689,  0.3482,  0.3008,  0.2215,  0.1332,  0.0582,  0.0071, -0.0323, -0.0664, -0.1089, -0.1483, -0.1547, -0.1265, -0.0914, -0.0706, -0.0642, -0.0680, -0.0717, -0.0568, -0.0185,  0.0140,  0.0236,  0.0028, -0.0552, -0.1323, -0.1829, -0.1973, -0.1871, -0.1786, -0.1925, -0.2217, -0.2457, -0.2499, -0.2366, -0.2143, -0.1887, -0.1531, -0.1047, -0.0531, -0.0036,  0.0406,  0.0752,  0.0874,  0.0810,  0.0640,  0.0411,  0.0167,  0.0071,  0.0167,  0.0395,  0.0629,  0.0741,  0.0842,  0.1060,  0.1295,  0.1460,  0.1481,  0.1300,  0.1034,  0.0864,  0.0853,  0.0954,  0.1167,  0.1422,  0.1651,  0.1917,  0.2252,  0.2502,  0.2518,  0.2385,  0.2220,  0.1960,  0.1598,  0.1295,  0.1108,  0.0709,  0.0018, -0.0711, -0.1073, -0.0978, -0.0680, -0.0461, -0.0451, -0.0568, -0.0722, -0.0791, -0.0653, -0.0265,  0.0252,  0.0757,  0.1209,  0.1534,  0.1715,  0.1805,  0.1704,  0.1332,  0.0677, -0.0078, -0.0770, -0.1350, -0.1951, -0.2372, -0.2451, -0.2521, -0.2712, -0.2898, -0.2840, -0.2393, -0.1717, -0.1121, -0.0749, -0.0626, -0.0637, -0.0738, -0.0919, -0.0988, -0.0770, -0.0493, -0.0249,  0.0012,  0.0241,  0.0433,  0.0560,  0.0640,  0.0800,  0.1119,  0.1582,  0.2061,  0.2502,  0.2582,  0.2162,  0.1273,  0.0374, -0.0142, -0.0163,  0.0071,  0.0252,  0.0289,  0.0204,  0.0124,  0.0049,  0.0002,  0.0023,  0.0151,  0.0252,  0.0225,  0.0140,  0.0135,  0.0167,  0.0076, -0.0131, -0.0371, -0.0674, -0.0999, -0.1185, -0.1132, -0.1047, -0.1174, -0.1355, -0.1456, -0.1393, -0.1238, -0.1105, -0.1068, -0.1164, -0.1291, -0.1393, -0.1382, -0.1196, -0.0882, -0.0642, -0.0472, -0.0296, -0.0153, -0.0073,  0.0012,  0.0326,  0.0943,  0.1593,  0.2008,  0.2295,  0.2481,  0.2439,  0.2103,  0.1614,  0.1183,  0.0869,  0.0592,  0.0214, -0.0302, -0.0818, -0.1201, -0.1520, -0.1765, -0.1898, -0.1935, -0.1845, -0.1600, -0.1174, -0.0653, -0.0206,  0.0060,  0.0193,  0.0331,  0.0406,  0.0422,  0.0534,  0.0901,  0.1263,  0.1257,  0.0997,  0.0885,  0.1071,  0.1428,  0.1598,  0.1518,  0.1220,  0.0789,  0.0337,  0.0044, -0.0153, -0.0222, -0.0217, -0.0227, -0.0249, -0.0185, -0.0062,  0.0103,  0.0321,  0.0464,  0.0422,  0.0246, -0.0030, -0.0328, -0.0318, -0.0211, -0.0461, -0.1111, -0.1595, -0.1504, -0.0951, -0.0280,  0.0204,  0.0427,  0.0300,  0.0076, -0.0046,  0.0140,  0.0603,  0.1082,  0.1401,  0.1566,  0.1646,  0.1837,  0.2066,  0.2109,  0.1821,  0.1247,  0.0518, -0.0004, -0.0105,  0.0039,  0.0002, -0.0435, -0.0983, -0.1307, -0.1190, -0.0903, -0.0823, -0.0940, -0.1142, -0.1350, -0.1329, -0.1004, -0.0440,  0.0284,  0.0981,  0.1481,  0.1763,  0.1800,  0.1609,  0.1199,  0.0603,  0.0055, -0.0270, -0.0360, -0.0249,  0.0044,  0.0129, -0.0387, -0.1366, -0.2249, -0.2718, -0.2856, -0.2861, -0.2904, -0.3063, -0.3271, -0.3319, -0.3069, -0.2537, -0.1845, -0.1174, -0.0509,  0.0300,  0.1156,  0.1848,  0.2199,  0.2242,  0.2013,  0.1630,  0.1241,  0.1007,  0.1071,  0.1273,  0.1087,  0.0640};
float32 test_wz[TEST_LENGTH] = {-0.0019, -0.0019, -0.0014, -0.0014, -0.0019, -0.0019, -0.0019, -0.0024, -0.0019, -0.0019, -0.0024, -0.0019, -0.0014, -0.0024, -0.0024, -0.0024, -0.0019, -0.0024, -0.0019, -0.0019, -0.0014, -0.0024, -0.0014, -0.0019, -0.0019, -0.0019, -0.0024, -0.0014, -0.0008, -0.0019, -0.0019, -0.0019, -0.0014, -0.0024, -0.0019, -0.0019, -0.0019, -0.0014, -0.0014, -0.0024, -0.0024, -0.0019, -0.0024, -0.0019, -0.0014, -0.0008, -0.0019, -0.0014, -0.0024, -0.0008, -0.0024, -0.0024, -0.0019, -0.0024, -0.0024, -0.0014, -0.0019, -0.0019, -0.0014, -0.0024, -0.0019, -0.0024, -0.0019, -0.0024, -0.0014, -0.0030, -0.0019, -0.0019, -0.0024, -0.0019, -0.0019, -0.0024, -0.0024, -0.0019, -0.0024, -0.0019, -0.0019, -0.0019, -0.0024, -0.0019, -0.0030, -0.0019, -0.0019, -0.0024, -0.0019, -0.0014, -0.0019, -0.0024, -0.0019, -0.0019, -0.0019, -0.0008, -0.0030, -0.0019, -0.0024, -0.0030, -0.0019, -0.0019, -0.0019, -0.0030, -0.0019, -0.0040, -0.0094, -0.0003, -0.0040, -0.0003, -0.0046,  0.0008, -0.0003,  0.0151,  0.0178,  0.0151,  0.0529,  0.0923,  0.1354,  0.1817,  0.2115,  0.1950,  0.1380,  0.0737,  0.0199, -0.0184, -0.0408, -0.0461, -0.0408, -0.0290, -0.0046,  0.0396,  0.0955,  0.1311,  0.1279,  0.1029,  0.0827,  0.0694,  0.0460,  0.0141, -0.0072, -0.0104, -0.0141, -0.0322, -0.0610, -0.0934, -0.1211, -0.1344, -0.1440, -0.1637, -0.1919, -0.2046, -0.1876, -0.1589, -0.1509, -0.1701, -0.2052, -0.2414, -0.2610, -0.2579, -0.2440, -0.2355, -0.2424, -0.2594, -0.2728, -0.2706, -0.2547, -0.2387, -0.2318, -0.2227, -0.1967, -0.1397, -0.0684, -0.0115,  0.0199,  0.0497,  0.1045,  0.1769,  0.2439,  0.2998,  0.3525,  0.4105,  0.4791,  0.5467,  0.5930,  0.6026,  0.5675,  0.5031,  0.4403,  0.3881,  0.3408,  0.2897,  0.2413,  0.2056,  0.1827,  0.1700,  0.1641,  0.1561,  0.1428,  0.1274,  0.1157,  0.1098,  0.1077,  0.1035,  0.0886,  0.0651,  0.0476,  0.0481,  0.0550,  0.0470,  0.0252,  0.0077,  0.0066,  0.0082, -0.0094, -0.0423, -0.0716, -0.0870, -0.0876, -0.0902, -0.1030, -0.1158, -0.1142, -0.0977, -0.0785, -0.0663, -0.0620, -0.0647, -0.0647, -0.0541, -0.0338, -0.0173, -0.0030,  0.0210,  0.0614,  0.1157,  0.1769,  0.2413,  0.3035,  0.3578,  0.3823,  0.3748,  0.3541,  0.3370,  0.3211,  0.2977,  0.2578,  0.2093,  0.1673,  0.1423,  0.1295,  0.1189,  0.1040,  0.0896,  0.0779,  0.0737,  0.0768,  0.0854,  0.0917,  0.0886,  0.0790,  0.0641,  0.0460,  0.0290,  0.0077, -0.0269, -0.0785, -0.1408, -0.2057, -0.2642, -0.3111, -0.3377, -0.3462, -0.3435, -0.3286, -0.3041, -0.2706, -0.2344, -0.1988, -0.1759, -0.1647, -0.1546, -0.1403, -0.1238, -0.0956, -0.0461,  0.0204,  0.0864,  0.1311,  0.1551,  0.1795,  0.2237,  0.2700,  0.2950,  0.2897,  0.2663,  0.2450,  0.2397,  0.2482,  0.2615,  0.2657,  0.2588,  0.2530,  0.2551,  0.2588,  0.2556,  0.2370,  0.2067,  0.1769,  0.1572,  0.1508,  0.1386,  0.1098,  0.0683,  0.0146, -0.0439, -0.0929, -0.1195, -0.1280, -0.1498, -0.1993, -0.2610, -0.3084, -0.3244, -0.3238, -0.3286, -0.3462, -0.3595, -0.3552, -0.3323, -0.2962, -0.2579, -0.2275, -0.2025, -0.1860, -0.1818, -0.1887, -0.1935, -0.1871, -0.1679, -0.1434, -0.1296, -0.1387, -0.1456, -0.1136, -0.0418,  0.0380,  0.1061,  0.1492,  0.1838,  0.2152,  0.2450,  0.2668,  0.2780,  0.2886,  0.3025,  0.3190,  0.3323,  0.3392,  0.3408,  0.3360,  0.3211,  0.2934,  0.2599,  0.2226,  0.1790,  0.1290,  0.0710,  0.0157, -0.0253, -0.0620, -0.1099, -0.1653, -0.2094, -0.2371, -0.2499, -0.2515, -0.2461, -0.2350, -0.2195, -0.1977, -0.1823, -0.1812, -0.1913, -0.1983, -0.1945, -0.1913, -0.1951, -0.1951, -0.1818, -0.1498, -0.1019, -0.0541, -0.0184, -0.0019, -0.0051, -0.0046,  0.0178,  0.0566,  0.0960,  0.1199,  0.1279,  0.1343,  0.1439,  0.1604,  0.1700,  0.1684,  0.1572,  0.1428,  0.1343,  0.1295,  0.1258,  0.1210,  0.1194,  0.1279,  0.1439,  0.1567,  0.1561,  0.1407,  0.1157,  0.0774,  0.0242, -0.0376, -0.0940, -0.1434, -0.1897, -0.2355, -0.2749, -0.2994, -0.2988, -0.2728, -0.2302, -0.1850, -0.1450, -0.1115, -0.0807, -0.0509, -0.0264, -0.0147, -0.0211, -0.0450, -0.0748, -0.0940, -0.0934, -0.0753, -0.0466, -0.0136,  0.0194,  0.0407,  0.0577,  0.0854,  0.1168,  0.1343,  0.1199,  0.0870,  0.0667,  0.0678,  0.0880,  0.1120,  0.1295,  0.1428,  0.1593,  0.1764,  0.1881,  0.1897,  0.1801,  0.1641,  0.1471,  0.1333,  0.1274,  0.1221,  0.1082,  0.0800,  0.0417, -0.0078, -0.0679, -0.1216, -0.1546, -0.1839, -0.2382, -0.3015, -0.3451, -0.3552, -0.3409, -0.3164, -0.2855, -0.2435, -0.1977, -0.1562, -0.1222, -0.0940, -0.0668, -0.0487, -0.0434, -0.0408, -0.0290, -0.0040,  0.0327,  0.0774,  0.1215,  0.1529,  0.1646,  0.1753,  0.2067};
float32 test_ax[TEST_LENGTH] = {-0.0487, -0.0468, -0.0446, -0.0456, -0.0445, -0.0446, -0.0457, -0.0437, -0.0456, -0.0456, -0.0454, -0.0452, -0.0470, -0.0465, -0.0449, -0.0456, -0.0463, -0.0457, -0.0439, -0.0467, -0.0459, -0.0470, -0.0449, -0.0457, -0.0462, -0.0446, -0.0445, -0.0449, -0.0455, -0.0444, -0.0452, -0.0455, -0.0450, -0.0454, -0.0451, -0.0457, -0.0440, -0.0444, -0.0448, -0.0467, -0.0471, -0.0448, -0.0457, -0.0434, -0.0445, -0.0443, -0.0450, -0.0443, -0.0451, -0.0433, -0.0446, -0.0434, -0.0440, -0.0454, -0.0440, -0.0435, -0.0455, -0.0459, -0.0465, -0.0476, -0.0450, -0.0432, -0.0459, -0.0446, -0.0457, -0.0446, -0.0445, -0.0448, -0.0459, -0.0452, -0.0454, -0.0459, -0.0452, -0.0461, -0.0456, -0.0449, -0.0462, -0.0450, -0.0463, -0.0456, -0.0451, -0.0451, -0.0443, -0.0446, -0.0454, -0.0450, -0.0473, -0.0440, -0.0444, -0.0481, -0.0467, -0.0459, -0.0450, -0.0439, -0.0455, -0.0455, -0.0433, -0.0462, -0.0461, -0.0465, -0.0473, -0.0465, -0.0577, -0.0472, -0.0318, -0.0383, -0.0507, -0.0389, -0.0498, -0.0550, -0.0858, -0.0504, -0.0221, -0.0114, -0.0907, -0.1395, -0.0880, -0.0737, -0.1174, -0.1168, -0.1042, -0.1001, -0.1042, -0.0992, -0.0671, -0.0830, -0.0899, -0.0772, -0.0329,  0.0137,  0.0354,  0.0113,  0.0031,  0.0053,  0.0160, -0.0004,  0.0035, -0.0029, -0.0046, -0.0183, -0.0222, -0.0293, -0.0282, -0.0180,  0.0148,  0.0436,  0.0398,  0.0038, -0.0240, -0.0020,  0.0237,  0.0357,  0.0312, -0.0057, -0.0401, -0.0300, -0.0080,  0.0053, -0.0124, -0.0494, -0.0307,  0.0230,  0.0876,  0.0846,  0.0401,  0.0271,  0.0368,  0.0621,  0.0738,  0.1119,  0.1047,  0.0727,  0.0568,  0.0630,  0.0887,  0.1073,  0.0616,  0.0124, -0.0163, -0.0330, -0.0428, -0.0349, -0.0117, -0.0301, -0.0926, -0.1132, -0.0802, -0.0498, -0.0600, -0.0959, -0.0983, -0.0944, -0.0943, -0.0594, -0.0417, -0.0671, -0.0874, -0.0640, -0.0264, -0.0113, -0.0039, -0.0349, -0.0776, -0.0446,  0.0131,  0.0357,  0.0276,  0.0378,  0.0314,  0.0249,  0.0448,  0.0490,  0.0660,  0.0899,  0.0903,  0.0669,  0.0588,  0.0629,  0.0622,  0.0512,  0.0479,  0.0575,  0.0601,  0.0529,  0.0511,  0.0669,  0.0758,  0.0795,  0.0857,  0.1028,  0.1004,  0.0970,  0.1459,  0.1941,  0.1778,  0.1231,  0.0772,  0.0683,  0.1087,  0.1324,  0.1125,  0.0755,  0.0507,  0.0330,  0.0231,  0.0093, -0.0062, -0.0053, -0.0022, -0.0106, -0.0369, -0.0399, -0.0351, -0.0455, -0.0394, -0.0462, -0.0521, -0.0460, -0.0232,  0.0219,  0.0420,  0.0332,  0.0185,  0.0129,  0.0204,  0.0288,  0.0074,  0.0119,  0.0342,  0.0485,  0.0479,  0.0475,  0.0253,  0.0031, -0.0004,  0.0129,  0.0065, -0.0207, -0.0253,  0.0180,  0.0425,  0.0590,  0.0796,  0.1084,  0.1153,  0.0729,  0.0700,  0.1076,  0.0932,  0.0513,  0.0216,  0.0166,  0.0580,  0.0905,  0.0846,  0.0468,  0.0157,  0.0075,  0.0065, -0.0236, -0.0496, -0.0503, -0.0350, -0.0214, -0.0190, -0.0224, -0.0157,  0.0185,  0.0265,  0.0193,  0.0060, -0.0095,  0.0052,  0.0498,  0.0787,  0.0705,  0.0341,  0.0314,  0.0518,  0.0476,  0.0232,  0.0127,  0.0220,  0.0369,  0.0490,  0.0442,  0.0191, -0.0102, -0.0002,  0.0385,  0.0386,  0.0312,  0.0268,  0.0596,  0.0812,  0.1054,  0.1332,  0.1546,  0.1455,  0.1120,  0.1482,  0.1570,  0.1119,  0.0780,  0.0707,  0.0883,  0.0859,  0.0549,  0.0162,  0.0028,  0.0143, -0.0018, -0.0264, -0.0290, -0.0037,  0.0232,  0.0348,  0.0495,  0.0429,  0.0462,  0.0557,  0.0711,  0.0970,  0.0959,  0.0650,  0.1070,  0.1530,  0.1471,  0.0986,  0.0636,  0.0622,  0.0634,  0.0645,  0.0440,  0.0364,  0.0583,  0.0739,  0.0638,  0.0479,  0.0424,  0.0509,  0.0468,  0.0308,  0.0249,  0.0551,  0.1084,  0.1340,  0.1465,  0.1822,  0.2041,  0.1834,  0.1331,  0.1289,  0.1626,  0.1210,  0.0719,  0.0536,  0.0690,  0.0872,  0.0747,  0.0540,  0.0284,  0.0025, -0.0201, -0.0345, -0.0505, -0.0495, -0.0321, -0.0223, -0.0109,  0.0109,  0.0310,  0.0312,  0.0330,  0.0318,  0.0451,  0.0774,  0.0675,  0.0285,  0.0487,  0.1022,  0.0834,  0.0275,  0.0132,  0.0287,  0.0424,  0.0382,  0.0382,  0.0634,  0.0778,  0.0758,  0.0470,  0.0176,  0.0103,  0.0038,  0.0094,  0.0193, -0.0050, -0.0116,  0.0102,  0.0668,  0.1259,  0.1397,  0.1144,  0.0755,  0.0754,  0.1109,  0.0879,  0.0358, -0.0062, -0.0191,  0.0306,  0.0767,  0.0541,  0.0177,  0.0301,  0.0230,  0.0166, -0.0080, -0.0317, -0.0235, -0.0232, -0.0249, -0.0305, -0.0333, -0.0080,  0.0204,  0.0131, -0.0045,  0.0026,  0.0077, -0.0123,  0.0259,  0.0715,  0.0412, -0.0141, -0.0026,  0.0342,  0.0386,  0.0357,  0.0468,  0.0795,  0.1028,  0.1095,  0.0998,  0.1014,  0.0979,  0.0699,  0.0497,  0.0556,  0.0863,  0.1176,  0.1458,  0.1601,  0.1659,  0.1936,  0.1961,  0.1424,  0.1311,  0.1701};
float32 test_ay[TEST_LENGTH] = {-0.0280, -0.0274, -0.0285, -0.0263, -0.0280, -0.0263, -0.0277, -0.0279, -0.0291, -0.0274, -0.0283, -0.0281, -0.0291, -0.0269, -0.0285, -0.0290, -0.0274, -0.0267, -0.0285, -0.0275, -0.0273, -0.0275, -0.0259, -0.0264, -0.0274, -0.0295, -0.0286, -0.0257, -0.0258, -0.0275, -0.0283, -0.0281, -0.0275, -0.0277, -0.0270, -0.0272, -0.0269, -0.0290, -0.0286, -0.0285, -0.0284, -0.0262, -0.0278, -0.0275, -0.0267, -0.0268, -0.0284, -0.0283, -0.0281, -0.0269, -0.0289, -0.0283, -0.0286, -0.0278, -0.0277, -0.0292, -0.0272, -0.0285, -0.0275, -0.0280, -0.0275, -0.0280, -0.0285, -0.0283, -0.0273, -0.0272, -0.0283, -0.0290, -0.0289, -0.0275, -0.0301, -0.0284, -0.0275, -0.0297, -0.0264, -0.0277, -0.0283, -0.0297, -0.0284, -0.0280, -0.0288, -0.0278, -0.0285, -0.0286, -0.0281, -0.0286, -0.0281, -0.0291, -0.0283, -0.0277, -0.0273, -0.0272, -0.0305, -0.0289, -0.0292, -0.0295, -0.0290, -0.0283, -0.0252, -0.0302, -0.0303, -0.0202, -0.0261, -0.0435, -0.0275, -0.0198, -0.0347, -0.0275, -0.0273, -0.0202,  0.0169,  0.0348, -0.0017, -0.0253,  0.0001,  0.0185, -0.0103, -0.0508, -0.0671, -0.0486, -0.0379, -0.0450, -0.0408, -0.0261, -0.0119, -0.0158, -0.0071,  0.0160,  0.0285,  0.0189,  0.0005, -0.0026,  0.0339,  0.0348,  0.0213,  0.0250,  0.0499,  0.0706,  0.0451,  0.0092, -0.0030, -0.0102, -0.0054,  0.0056,  0.0178,  0.0024, -0.0018,  0.0341,  0.0667,  0.0539,  0.0143, -0.0165, -0.0338, -0.0379, -0.0151,  0.0157,  0.0119, -0.0283, -0.0699, -0.0899, -0.0718, -0.0275, -0.0106, -0.0277, -0.0577, -0.0621, -0.0411,  0.0202,  0.0344, -0.0257, -0.0754, -0.0613, -0.0252, -0.0261, -0.0501, -0.0667, -0.0700, -0.0557, -0.0214,  0.0109,  0.0062, -0.0178, -0.0546, -0.0589, -0.0439, -0.0330, -0.0419, -0.0446, -0.0290, -0.0163, -0.0157, -0.0119, -0.0024,  0.0002, -0.0071, -0.0082,  0.0005,  0.0145,  0.0219,  0.0242,  0.0201,  0.0023,  0.0175,  0.0414,  0.0486,  0.0294,  0.0135,  0.0358,  0.0773,  0.0795,  0.0530,  0.0378,  0.0460,  0.0692,  0.0850,  0.0707,  0.0383,  0.0311,  0.0477,  0.0616,  0.0539,  0.0385,  0.0364,  0.0290,  0.0345,  0.0550,  0.0662,  0.0534,  0.0359,  0.0234,  0.0286,  0.0252,  0.0351,  0.0386,  0.0594,  0.0615,  0.0139, -0.0264, -0.0119,  0.0180,  0.0412,  0.0379,  0.0137, -0.0018,  0.0123,  0.0283,  0.0313,  0.0241,  0.0110,  0.0120,  0.0106,  0.0142,  0.0269,  0.0384,  0.0379,  0.0377,  0.0302,  0.0142,  0.0104,  0.0198,  0.0233,  0.0117, -0.0082, -0.0151, -0.0126, -0.0115, -0.0003,  0.0045, -0.0073, -0.0256, -0.0414, -0.0402, -0.0410, -0.0454, -0.0508, -0.0726, -0.0726, -0.0574, -0.0436, -0.0484, -0.0443, -0.0302, -0.0217, -0.0330, -0.0726, -0.1049, -0.0692, -0.0269, -0.0288, -0.0640, -0.1037, -0.1213, -0.1063, -0.0699, -0.0342, -0.0259, -0.0351, -0.0433, -0.0169,  0.0059,  0.0117, -0.0017, -0.0191, -0.0347, -0.0203,  0.0065,  0.0323,  0.0209,  0.0026, -0.0054, -0.0093, -0.0086,  0.0077,  0.0396,  0.0521,  0.0246, -0.0070, -0.0091,  0.0176,  0.0596,  0.0679,  0.0333,  0.0009, -0.0098, -0.0046,  0.0001,  0.0134,  0.0085, -0.0008, -0.0038, -0.0106, -0.0241, -0.0327, -0.0275, -0.0092,  0.0002, -0.0112, -0.0428, -0.0792, -0.0732, -0.0123,  0.0312,  0.0298, -0.0060, -0.0242, -0.0141,  0.0029,  0.0153,  0.0128,  0.0063,  0.0195,  0.0419,  0.0568,  0.0623,  0.0610,  0.0665,  0.0628,  0.0573,  0.0472,  0.0445,  0.0358,  0.0276,  0.0330,  0.0410,  0.0567,  0.0787,  0.0706,  0.0528,  0.0471,  0.0657,  0.0881,  0.1011,  0.1076,  0.1071,  0.0893,  0.0796,  0.0789,  0.0742,  0.0507,  0.0377,  0.0483,  0.0640,  0.0573,  0.0449,  0.0380,  0.0429,  0.0534,  0.0552,  0.0407,  0.0097, -0.0269, -0.0472, -0.0268,  0.0125,  0.0218,  0.0015, -0.0344, -0.0479, -0.0385, -0.0190, -0.0051, -0.0013, -0.0102, -0.0173, -0.0189, -0.0179, -0.0185, -0.0262, -0.0379, -0.0433, -0.0380, -0.0248, -0.0165, -0.0204, -0.0273, -0.0363, -0.0402, -0.0463, -0.0430, -0.0408, -0.0375, -0.0457, -0.0505, -0.0486, -0.0333, -0.0057,  0.0186,  0.0174,  0.0058, -0.0143, -0.0185, -0.0174, -0.0139, -0.0004,  0.0052,  0.0063, -0.0008,  0.0063,  0.0222,  0.0311,  0.0494,  0.0538,  0.0508,  0.0319,  0.0027,  0.0126,  0.0340,  0.0274, -0.0141, -0.0693, -0.0945, -0.0743, -0.0455, -0.0345, -0.0381, -0.0483, -0.0407, -0.0229, -0.0209, -0.0195, -0.0189, -0.0213, -0.0208, -0.0179, -0.0030,  0.0062,  0.0113,  0.0103,  0.0019, -0.0023, -0.0142, -0.0322, -0.0087,  0.0254,  0.0204, -0.0189, -0.0303, -0.0015,  0.0270,  0.0403,  0.0222,  0.0135,  0.0173,  0.0117, -0.0096, -0.0268, -0.0212, -0.0158, -0.0285, -0.0521, -0.0519, -0.0347, -0.0106,  0.0023,  0.0018, -0.0054, -0.0386, -0.0722, -0.0401,  0.0020};
float32 test_az[TEST_LENGTH] = {1.0069,  1.0048,  1.0053,  1.0037,  1.0066,  1.0056,  1.0071,  1.0031,  1.0072,  1.0092,  1.0045,  1.0070,  1.0055,  1.0070,  1.0050,  1.0065,  1.0045,  1.0031,  1.0071,  1.0069,  1.0048,  1.0044,  1.0065,  1.0044,  1.0041,  1.0055,  1.0060,  1.0059,  1.0063,  1.0047,  1.0056,  1.0074,  1.0070,  1.0070,  1.0052,  1.0066,  1.0053,  1.0049,  1.0076,  1.0065,  1.0043,  1.0066,  1.0083,  1.0065,  1.0063,  1.0045,  1.0056,  1.0060,  1.0064,  1.0080,  1.0080,  1.0077,  1.0050,  1.0074,  1.0069,  1.0061,  1.0032,  1.0071,  1.0055,  1.0049,  1.0050,  1.0067,  1.0077,  1.0037,  1.0065,  1.0070,  1.0085,  1.0066,  1.0082,  1.0061,  1.0072,  1.0075,  1.0069,  1.0082,  1.0080,  1.0056,  1.0049,  1.0097,  1.0069,  1.0065,  1.0085,  1.0074,  1.0074,  1.0041,  1.0077,  1.0077,  1.0045,  1.0054,  1.0065,  1.0050,  1.0100,  1.0032,  1.0052,  1.0054,  1.0041,  1.0104,  1.0059,  1.0092,  1.0058,  1.0041,  1.0052,  1.0205,  1.0011,  1.0054,  1.0031,  1.0039,  1.0056,  1.0011,  1.0111,  1.0377,  0.9991,  1.0335,  1.1278,  1.1659,  1.2210,  1.2698,  1.2578,  1.2453,  1.2582,  1.2570,  1.2343,  1.2024,  1.2051,  1.2451,  1.2348,  1.2145,  1.2055,  1.2127,  1.1992,  1.1991,  1.1989,  1.2115,  1.2151,  1.2227,  1.2179,  1.2238,  1.2643,  1.2870,  1.2397,  1.1894,  1.1222,  1.0652,  1.0508,  1.0844,  1.0568,  0.9912,  0.9208,  0.8688,  0.8721,  0.8793,  0.8692,  0.8374,  0.7786,  0.7610,  0.7696,  0.7818,  0.8017,  0.8324,  0.8526,  0.8222,  0.7941,  0.7867,  0.8056,  0.8319,  0.8222,  0.7841,  0.8041,  0.9042,  0.9737,  0.9418,  0.8876,  0.9098,  0.9727,  1.0417,  1.0670,  1.0348,  1.0058,  0.9954,  0.9875,  0.9519,  0.8787,  0.8228,  0.8034,  0.8365,  0.8817,  0.9099,  0.9091,  0.9007,  0.8904,  0.8738,  0.8693,  0.8991,  0.9456,  0.9551,  0.9464,  0.9543,  0.9767,  0.9871,  1.0014,  1.0002,  1.0136,  1.0451,  1.0443,  1.0546,  1.0628,  1.0869,  1.1203,  1.1321,  1.0981,  1.0382,  0.9873,  0.9905,  1.0104,  1.0110,  0.9834,  0.9202,  0.8664,  0.8583,  0.8889,  0.8979,  0.8919,  0.9120,  0.9362,  0.9560,  0.9978,  1.0473,  1.1007,  1.1243,  1.1471,  1.1802,  1.1955,  1.1516,  1.0670,  1.0782,  1.1215,  1.0932,  1.0025,  0.9175,  0.8808,  0.9023,  0.9267,  0.9132,  0.8864,  0.8705,  0.8747,  0.8811,  0.9023,  0.9049,  0.8990,  0.9203,  0.9578,  0.9969,  1.0351,  1.0738,  1.1106,  1.1480,  1.1630,  1.1794,  1.2132,  1.2416,  1.2075,  1.1144,  1.0296,  0.9779,  0.9673,  0.9831,  0.9814,  0.9513,  0.9181,  0.8780,  0.8347,  0.8241,  0.8291,  0.8358,  0.8349,  0.8416,  0.8784,  0.9480,  1.0109,  1.0689,  1.1214,  1.1487,  1.1795,  1.2038,  1.1906,  1.1608,  1.1503,  1.1625,  1.1527,  1.0862,  0.9751,  0.8909,  0.8527,  0.8755,  0.8997,  0.8909,  0.8540,  0.8299,  0.8151,  0.8299,  0.8699,  0.8900,  0.9099,  0.9546,  1.0200,  1.0960,  1.1529,  1.1662,  1.1703,  1.1829,  1.1806,  1.1856,  1.2171,  1.2526,  1.2685,  1.1952,  1.0838,  0.9953,  0.9682,  0.9866,  0.9793,  0.9243,  0.8523,  0.8103,  0.7959,  0.7981,  0.8297,  0.8455,  0.8623,  0.8777,  0.9048,  0.9517,  1.0200,  1.0745,  1.1192,  1.1413,  1.1468,  1.1297,  1.1132,  1.1241,  1.1597,  1.1786,  1.1595,  1.0775,  0.9991,  0.9514,  0.9355,  0.9158,  0.8726,  0.8368,  0.8201,  0.8059,  0.8172,  0.8535,  0.8842,  0.9223,  0.9762,  1.0396,  1.0882,  1.0935,  1.0829,  1.1182,  1.1817,  1.2138,  1.2052,  1.1828,  1.1776,  1.1614,  1.1075,  1.0393,  0.9868,  0.9771,  0.9820,  0.9538,  0.8974,  0.8471,  0.8244,  0.8238,  0.8164,  0.8108,  0.8141,  0.8465,  0.9018,  0.9648,  1.0218,  1.0679,  1.1182,  1.1612,  1.1774,  1.1612,  1.1357,  1.1355,  1.1753,  1.2121,  1.1907,  1.1075,  1.0297,  0.9785,  0.9496,  0.9374,  0.9258,  0.8821,  0.8428,  0.8208,  0.8084,  0.8107,  0.8378,  0.8682,  0.8932,  0.9234,  0.9554,  1.0013,  1.0788,  1.1328,  1.1591,  1.1794,  1.1839,  1.1718,  1.1668,  1.1933,  1.2155,  1.1640,  1.0448,  0.9407,  0.9064,  0.9265,  0.9540,  0.9568,  0.9259,  0.8814,  0.8321,  0.8177,  0.8363,  0.8546,  0.8748,  0.8998,  0.9236,  0.9628,  1.0203,  1.0806,  1.1503,  1.1975,  1.2100,  1.1822,  1.1419,  1.1376,  1.1624,  1.1637,  1.1007,  0.9926,  0.9261,  0.9109,  0.9356,  0.9545,  0.9279,  0.8675,  0.8290,  0.8079,  0.8058,  0.8208,  0.8496,  0.9068,  0.9659,  1.0196,  1.0628,  1.1000,  1.1377,  1.1658,  1.1775,  1.1573,  1.1311,  1.1374,  1.1896,  1.1980,  1.1275,  1.0358,  0.9855,  0.9898,  1.0190,  1.0215,  0.9804,  0.9234,  0.8776,  0.8393,  0.8123,  0.8091,  0.8179,  0.8350,  0.8484,  0.8858,  0.9595,  1.0439,  1.1241,  1.1913,  1.2122,  1.1896,  1.1608,  1.1715,  1.1906,  1.1928};
float32 test_mag_x[TEST_LENGTH] = {0.4757,  0.4749,  0.4774,  0.4756,  0.4723,  0.4764,  0.4772,  0.4738,  0.4764,  0.4782,  0.4733,  0.4761,  0.4774,  0.4764,  0.4762,  0.4769,  0.4764,  0.4741,  0.4787,  0.4779,  0.4733,  0.4746,  0.4767,  0.4738,  0.4730,  0.4751,  0.4725,  0.4725,  0.4795,  0.4764,  0.4746,  0.4761,  0.4761,  0.4733,  0.4741,  0.4774,  0.4738,  0.4733,  0.4784,  0.4749,  0.4736,  0.4774,  0.4751,  0.4733,  0.4764,  0.4787,  0.4752,  0.4759,  0.4793,  0.4746,  0.4749,  0.4782,  0.4764,  0.4736,  0.4754,  0.4736,  0.4749,  0.4764,  0.4782,  0.4733,  0.4762,  0.4774,  0.4751,  0.4743,  0.4774,  0.4749,  0.4746,  0.4784,  0.4769,  0.4736,  0.4777,  0.4761,  0.4746,  0.4743,  0.4782,  0.4741,  0.4764,  0.4782,  0.4761,  0.4731,  0.4764,  0.4756,  0.4762,  0.4774,  0.4779,  0.4749,  0.4743,  0.4759,  0.4738,  0.4764,  0.4766,  0.4762,  0.4746,  0.4777,  0.4769,  0.4736,  0.4769,  0.4767,  0.4767,  0.4753,  0.4762,  0.4767,  0.4754,  0.4787,  0.4769,  0.4728,  0.4777,  0.4753,  0.4728,  0.4741,  0.4774,  0.4756,  0.4780,  0.4828,  0.4857,  0.4876,  0.4953,  0.4947,  0.4950,  0.5008,  0.5027,  0.5032,  0.5115,  0.5126,  0.5105,  0.5145,  0.5272,  0.5253,  0.5264,  0.5277,  0.5261,  0.5244,  0.5256,  0.5244,  0.5194,  0.5191,  0.5217,  0.5204,  0.5251,  0.5282,  0.5267,  0.5281,  0.5344,  0.5359,  0.5384,  0.5447,  0.5497,  0.5492,  0.5552,  0.5563,  0.5549,  0.5552,  0.5601,  0.5590,  0.5635,  0.5658,  0.5701,  0.5712,  0.5796,  0.5815,  0.5856,  0.5905,  0.5979,  0.5983,  0.6039,  0.6060,  0.6071,  0.6053,  0.6106,  0.6072,  0.6042,  0.6062,  0.6004,  0.5971,  0.5916,  0.5886,  0.5817,  0.5772,  0.5690,  0.5628,  0.5493,  0.5489,  0.5368,  0.5299,  0.5229,  0.5160,  0.5083,  0.5057,  0.5043,  0.4993,  0.4986,  0.5033,  0.4999,  0.5000,  0.5044,  0.5040,  0.5044,  0.5054,  0.5069,  0.5021,  0.5053,  0.5101,  0.5055,  0.5068,  0.5069,  0.5036,  0.5053,  0.5098,  0.5124,  0.5132,  0.5151,  0.5225,  0.5214,  0.5247,  0.5299,  0.5322,  0.5339,  0.5412,  0.5414,  0.5458,  0.5480,  0.5494,  0.5497,  0.5500,  0.5513,  0.5469,  0.5464,  0.5455,  0.5449,  0.5418,  0.5431,  0.5416,  0.5395,  0.5410,  0.5392,  0.5334,  0.5322,  0.5283,  0.5223,  0.5182,  0.5161,  0.5119,  0.5075,  0.5093,  0.5039,  0.4981,  0.4984,  0.4942,  0.4888,  0.4853,  0.4841,  0.4774,  0.4759,  0.4707,  0.4646,  0.4613,  0.4631,  0.4597,  0.4570,  0.4553,  0.4582,  0.4567,  0.4615,  0.4648,  0.4636,  0.4654,  0.4735,  0.4714,  0.4791,  0.4796,  0.4840,  0.4837,  0.4880,  0.4846,  0.4842,  0.4864,  0.4841,  0.4808,  0.4778,  0.4776,  0.4811,  0.4818,  0.4854,  0.4859,  0.4880,  0.4911,  0.4941,  0.4940,  0.4976,  0.5008,  0.5007,  0.5002,  0.5035,  0.5019,  0.4992,  0.5013,  0.5007,  0.4982,  0.4987,  0.4984,  0.4947,  0.4963,  0.4956,  0.4902,  0.4898,  0.4909,  0.4863,  0.4840,  0.4838,  0.4818,  0.4736,  0.4739,  0.4701,  0.4683,  0.4662,  0.4672,  0.4673,  0.4683,  0.4739,  0.4754,  0.4746,  0.4802,  0.4792,  0.4807,  0.4845,  0.4878,  0.4888,  0.4914,  0.4926,  0.4887,  0.4892,  0.4974,  0.4970,  0.4983,  0.5015,  0.5024,  0.5043,  0.5082,  0.5077,  0.5103,  0.5144,  0.5179,  0.5209,  0.5230,  0.5236,  0.5233,  0.5233,  0.5227,  0.5232,  0.5231,  0.5229,  0.5256,  0.5235,  0.5241,  0.5219,  0.5183,  0.5203,  0.5173,  0.5134,  0.5118,  0.5107,  0.5058,  0.5023,  0.4978,  0.4947,  0.4889,  0.4886,  0.4883,  0.4857,  0.4859,  0.4871,  0.4865,  0.4871,  0.4933,  0.4938,  0.4980,  0.5027,  0.5055,  0.5076,  0.5135,  0.5181,  0.5185,  0.5195,  0.5227,  0.5207,  0.5209,  0.5239,  0.5254,  0.5235,  0.5248,  0.5259,  0.5213,  0.5204,  0.5188,  0.5156,  0.5123,  0.5132,  0.5094,  0.5030,  0.5054,  0.5007,  0.4984,  0.4981,  0.4977,  0.4942,  0.4934,  0.4972,  0.4925,  0.4921,  0.4924,  0.4895,  0.4902,  0.4878,  0.4850,  0.4834,  0.4807,  0.4855,  0.4841,  0.4842,  0.4851,  0.4875,  0.4902,  0.4981,  0.4993,  0.5008,  0.5038,  0.5066,  0.5067,  0.5090,  0.5084,  0.5102,  0.5120,  0.5085,  0.5053,  0.5006,  0.5011,  0.4983,  0.4947,  0.4958,  0.4938,  0.4919,  0.4939,  0.4937,  0.4931,  0.4952,  0.4907,  0.4917,  0.4916,  0.4940,  0.4928,  0.4952,  0.4964,  0.4971,  0.4960,  0.4986,  0.4992,  0.4998,  0.4976,  0.4993,  0.4942,  0.4939,  0.4898,  0.4850,  0.4799,  0.4774,  0.4777,  0.4739,  0.4774,  0.4746,  0.4734,  0.4749,  0.4774,  0.4772,  0.4794,  0.4837,  0.4914,  0.4951,  0.5035,  0.5104,  0.5151,  0.5208,  0.5314,  0.5358,  0.5411,  0.5444,  0.5460,  0.5460,  0.5490,  0.5476,  0.5431,  0.5427,  0.5405,  0.5357,  0.5332,  0.5317,  0.5273,  0.5290,  0.5250,  0.5213,  0.5197};
float32 test_mag_y[TEST_LENGTH] = {-0.2906, -0.2901, -0.2873, -0.2880, -0.2906, -0.2884, -0.2915, -0.2940, -0.2884, -0.2878, -0.2919, -0.2899, -0.2873, -0.2910, -0.2873, -0.2852, -0.2910, -0.2896, -0.2871, -0.2894, -0.2919, -0.2892, -0.2896, -0.2915, -0.2882, -0.2861, -0.2889, -0.2914, -0.2876, -0.2884, -0.2917, -0.2901, -0.2901, -0.2919, -0.2898, -0.2873, -0.2940, -0.2919, -0.2861, -0.2903, -0.2903, -0.2873, -0.2913, -0.2919, -0.2884, -0.2871, -0.2938, -0.2918, -0.2891, -0.2917, -0.2901, -0.2878, -0.2884, -0.2903, -0.2871, -0.2931, -0.2901, -0.2859, -0.2903, -0.2919, -0.2873, -0.2927, -0.2913, -0.2908, -0.2873, -0.2901, -0.2917, -0.2861, -0.2906, -0.2903, -0.2882, -0.2901, -0.2917, -0.2882, -0.2878, -0.2924, -0.2910, -0.2903, -0.2901, -0.2910, -0.2884, -0.2933, -0.2926, -0.2873, -0.2894, -0.2901, -0.2908, -0.2891, -0.2915, -0.2910, -0.2869, -0.2926, -0.2917, -0.2882, -0.2906, -0.2928, -0.2877, -0.2896, -0.2894, -0.2896, -0.2876, -0.2919, -0.2921, -0.2871, -0.2906, -0.2899, -0.2882, -0.2896, -0.2926, -0.2898, -0.2873, -0.2931, -0.2945, -0.2983, -0.3041, -0.3121, -0.3110, -0.3196, -0.3212, -0.3150, -0.3095, -0.3034, -0.2886, -0.2875, -0.2801, -0.2750, -0.2730, -0.2738, -0.2682, -0.2697, -0.2742, -0.2734, -0.2685, -0.2687, -0.2705, -0.2642, -0.2709, -0.2693, -0.2664, -0.2698, -0.2763, -0.2788, -0.2768, -0.2803, -0.2862, -0.2842, -0.2913, -0.2955, -0.2898, -0.2886, -0.2933, -0.2906, -0.2852, -0.2863, -0.2799, -0.2774, -0.2771, -0.2777, -0.2693, -0.2705, -0.2720, -0.2718, -0.2638, -0.2679, -0.2646, -0.2582, -0.2638, -0.2630, -0.2545, -0.2573, -0.2578, -0.2515, -0.2500, -0.2523, -0.2481, -0.2471, -0.2539, -0.2559, -0.2528, -0.2605, -0.2679, -0.2675, -0.2763, -0.2807, -0.2751, -0.2758, -0.2807, -0.2802, -0.2750, -0.2767, -0.2737, -0.2681, -0.2708, -0.2663, -0.2624, -0.2613, -0.2607, -0.2513, -0.2493, -0.2453, -0.2415, -0.2367, -0.2353, -0.2252, -0.2206, -0.2192, -0.2184, -0.2096, -0.2105, -0.2137, -0.2084, -0.2087, -0.2129, -0.2101, -0.2090, -0.2155, -0.2162, -0.2124, -0.2148, -0.2157, -0.2130, -0.2182, -0.2177, -0.2131, -0.2101, -0.2144, -0.2106, -0.2079, -0.2071, -0.2054, -0.2024, -0.2071, -0.2098, -0.2110, -0.2163, -0.2295, -0.2297, -0.2380, -0.2429, -0.2496, -0.2537, -0.2630, -0.2686, -0.2723, -0.2747, -0.2804, -0.2815, -0.2855, -0.2878, -0.2868, -0.2871, -0.2897, -0.2914, -0.2898, -0.2944, -0.2969, -0.2963, -0.3016, -0.3033, -0.3055, -0.3112, -0.3155, -0.3142, -0.3195, -0.3246, -0.3240, -0.3251, -0.3296, -0.3286, -0.3254, -0.3328, -0.3344, -0.3302, -0.3325, -0.3336, -0.3314, -0.3304, -0.3327, -0.3259, -0.3252, -0.3312, -0.3289, -0.3249, -0.3294, -0.3304, -0.3296, -0.3311, -0.3335, -0.3296, -0.3288, -0.3319, -0.3298, -0.3266, -0.3256, -0.3196, -0.3175, -0.3179, -0.3155, -0.3090, -0.3106, -0.3118, -0.3075, -0.3075, -0.3121, -0.3075, -0.3040, -0.3092, -0.3105, -0.3072, -0.3123, -0.3137, -0.3096, -0.3104, -0.3110, -0.3082, -0.3072, -0.3148, -0.3110, -0.3072, -0.3078, -0.3073, -0.3060, -0.3071, -0.3077, -0.2996, -0.3020, -0.3034, -0.2979, -0.2977, -0.3006, -0.2975, -0.2958, -0.3000, -0.2944, -0.2919, -0.2905, -0.2880, -0.2796, -0.2776, -0.2737, -0.2662, -0.2619, -0.2593, -0.2525, -0.2465, -0.2465, -0.2465, -0.2380, -0.2384, -0.2412, -0.2401, -0.2424, -0.2449, -0.2442, -0.2457, -0.2570, -0.2572, -0.2599, -0.2649, -0.2693, -0.2669, -0.2730, -0.2747, -0.2669, -0.2654, -0.2657, -0.2647, -0.2584, -0.2588, -0.2544, -0.2515, -0.2522, -0.2516, -0.2479, -0.2473, -0.2514, -0.2538, -0.2544, -0.2583, -0.2579, -0.2603, -0.2633, -0.2647, -0.2610, -0.2608, -0.2629, -0.2608, -0.2643, -0.2651, -0.2623, -0.2610, -0.2665, -0.2625, -0.2634, -0.2696, -0.2687, -0.2717, -0.2723, -0.2777, -0.2790, -0.2887, -0.2925, -0.2936, -0.2977, -0.3070, -0.3093, -0.3141, -0.3192, -0.3200, -0.3213, -0.3281, -0.3309, -0.3268, -0.3312, -0.3325, -0.3323, -0.3333, -0.3330, -0.3307, -0.3260, -0.3278, -0.3258, -0.3207, -0.3205, -0.3158, -0.3097, -0.3076, -0.3033, -0.2985, -0.2964, -0.2964, -0.2929, -0.2912, -0.2893, -0.2860, -0.2802, -0.2820, -0.2784, -0.2747, -0.2718, -0.2699, -0.2675, -0.2665, -0.2671, -0.2647, -0.2649, -0.2690, -0.2715, -0.2703, -0.2731, -0.2752, -0.2768, -0.2798, -0.2809, -0.2832, -0.2827, -0.2908, -0.2949, -0.2933, -0.2965, -0.2981, -0.2970, -0.3013, -0.3020, -0.3000, -0.3036, -0.3064, -0.3053, -0.3073, -0.3124, -0.3106, -0.3105, -0.3145, -0.3079, -0.3068, -0.3038, -0.3031, -0.2946, -0.2914, -0.2876, -0.2846, -0.2833, -0.2840, -0.2816, -0.2789, -0.2799, -0.2799, -0.2770, -0.2798, -0.2774, -0.2728, -0.2742, -0.2735, -0.2677, -0.2685, -0.2681, -0.2646, -0.2597, -0.2587, -0.2551};
float32 test_mag_z[TEST_LENGTH] = {0.8302,  0.8309,  0.8304,  0.8312,  0.8322,  0.8306,  0.8290,  0.8301,  0.8306,  0.8298,  0.8311,  0.8302,  0.8304,  0.8297,  0.8311,  0.8314,  0.8297,  0.8315,  0.8297,  0.8294,  0.8311,  0.8314,  0.8300,  0.8310,  0.8326,  0.8321,  0.8326,  0.8317,  0.8291,  0.8306,  0.8305,  0.8301,  0.8301,  0.8311,  0.8314,  0.8304,  0.8301,  0.8311,  0.8302,  0.8308,  0.8315,  0.8304,  0.8303,  0.8311,  0.8306,  0.8297,  0.8294,  0.8297,  0.8287,  0.8305,  0.8309,  0.8298,  0.8306,  0.8315,  0.8316,  0.8306,  0.8309,  0.8314,  0.8288,  0.8311,  0.8311,  0.8285,  0.8303,  0.8309,  0.8304,  0.8309,  0.8305,  0.8302,  0.8295,  0.8315,  0.8299,  0.8301,  0.8305,  0.8318,  0.8298,  0.8305,  0.8297,  0.8288,  0.8301,  0.8316,  0.8306,  0.8293,  0.8292,  0.8304,  0.8294,  0.8309,  0.8309,  0.8306,  0.8310,  0.8297,  0.8310,  0.8292,  0.8305,  0.8299,  0.8295,  0.8306,  0.8305,  0.8300,  0.8301,  0.8308,  0.8310,  0.8292,  0.8298,  0.8297,  0.8295,  0.8322,  0.8299,  0.8308,  0.8311,  0.8314,  0.8304,  0.8294,  0.8275,  0.8233,  0.8195,  0.8154,  0.8111,  0.8082,  0.8074,  0.8062,  0.8072,  0.8092,  0.8094,  0.8091,  0.8130,  0.8122,  0.8047,  0.8057,  0.8068,  0.8055,  0.8050,  0.8064,  0.8072,  0.8080,  0.8106,  0.8129,  0.8090,  0.8103,  0.8083,  0.8052,  0.8039,  0.8021,  0.7986,  0.7964,  0.7926,  0.7890,  0.7829,  0.7817,  0.7796,  0.7792,  0.7785,  0.7793,  0.7778,  0.7782,  0.7772,  0.7764,  0.7734,  0.7724,  0.7691,  0.7672,  0.7636,  0.7599,  0.7569,  0.7552,  0.7519,  0.7524,  0.7496,  0.7513,  0.7499,  0.7518,  0.7540,  0.7545,  0.7596,  0.7614,  0.7671,  0.7697,  0.7728,  0.7755,  0.7825,  0.7845,  0.7915,  0.7919,  0.7972,  0.8003,  0.8068,  0.8110,  0.8141,  0.8160,  0.8186,  0.8210,  0.8225,  0.8215,  0.8226,  0.8241,  0.8227,  0.8232,  0.8232,  0.8255,  0.8252,  0.8293,  0.8285,  0.8269,  0.8301,  0.8321,  0.8333,  0.8357,  0.8349,  0.8344,  0.8325,  0.8312,  0.8314,  0.8267,  0.8263,  0.8250,  0.8219,  0.8187,  0.8175,  0.8136,  0.8129,  0.8097,  0.8089,  0.8066,  0.8065,  0.8075,  0.8074,  0.8093,  0.8106,  0.8119,  0.8125,  0.8150,  0.8149,  0.8147,  0.8154,  0.8141,  0.8139,  0.8141,  0.8149,  0.8150,  0.8174,  0.8180,  0.8181,  0.8178,  0.8187,  0.8164,  0.8189,  0.8206,  0.8200,  0.8211,  0.8236,  0.8260,  0.8266,  0.8296,  0.8298,  0.8333,  0.8352,  0.8361,  0.8353,  0.8353,  0.8362,  0.8363,  0.8326,  0.8318,  0.8297,  0.8257,  0.8245,  0.8237,  0.8186,  0.8180,  0.8140,  0.8149,  0.8093,  0.8088,  0.8080,  0.8091,  0.8089,  0.8085,  0.8102,  0.8113,  0.8157,  0.8162,  0.8117,  0.8122,  0.8117,  0.8096,  0.8079,  0.8063,  0.8039,  0.8030,  0.8023,  0.8007,  0.7994,  0.8006,  0.7999,  0.8013,  0.8054,  0.8049,  0.8052,  0.8076,  0.8098,  0.8094,  0.8112,  0.8119,  0.8123,  0.8138,  0.8158,  0.8165,  0.8173,  0.8181,  0.8195,  0.8188,  0.8230,  0.8244,  0.8263,  0.8271,  0.8293,  0.8291,  0.8261,  0.8271,  0.8253,  0.8242,  0.8248,  0.8220,  0.8222,  0.8212,  0.8219,  0.8191,  0.8179,  0.8184,  0.8178,  0.8190,  0.8199,  0.8156,  0.8142,  0.8155,  0.8144,  0.8143,  0.8141,  0.8146,  0.8156,  0.8153,  0.8152,  0.8143,  0.8133,  0.8141,  0.8155,  0.8157,  0.8157,  0.8186,  0.8182,  0.8174,  0.8179,  0.8155,  0.8161,  0.8159,  0.8168,  0.8156,  0.8143,  0.8154,  0.8163,  0.8158,  0.8173,  0.8183,  0.8199,  0.8252,  0.8275,  0.8309,  0.8314,  0.8336,  0.8350,  0.8362,  0.8363,  0.8365,  0.8363,  0.8338,  0.8337,  0.8299,  0.8264,  0.8245,  0.8220,  0.8184,  0.8147,  0.8135,  0.8125,  0.8116,  0.8129,  0.8121,  0.8109,  0.8088,  0.8098,  0.8098,  0.8095,  0.8107,  0.8126,  0.8133,  0.8133,  0.8157,  0.8141,  0.8163,  0.8185,  0.8165,  0.8161,  0.8161,  0.8159,  0.8146,  0.8134,  0.8129,  0.8087,  0.8096,  0.8096,  0.8089,  0.8080,  0.8064,  0.8095,  0.8094,  0.8098,  0.8115,  0.8082,  0.8092,  0.8100,  0.8114,  0.8093,  0.8084,  0.8056,  0.8050,  0.8059,  0.8064,  0.8055,  0.8070,  0.8073,  0.8085,  0.8074,  0.8075,  0.8104,  0.8130,  0.8171,  0.8188,  0.8199,  0.8232,  0.8238,  0.8260,  0.8278,  0.8273,  0.8278,  0.8280,  0.8275,  0.8301,  0.8282,  0.8274,  0.8264,  0.8262,  0.8240,  0.8228,  0.8214,  0.8216,  0.8193,  0.8190,  0.8159,  0.8157,  0.8153,  0.8172,  0.8168,  0.8197,  0.8210,  0.8237,  0.8259,  0.8244,  0.8256,  0.8239,  0.8248,  0.8236,  0.8234,  0.8220,  0.8206,  0.8218,  0.8197,  0.8162,  0.8143,  0.8122,  0.8091,  0.8074,  0.8048,  0.7983,  0.7952,  0.7924,  0.7911,  0.7896,  0.7896,  0.7886,  0.7886,  0.7926,  0.7944,  0.7954,  0.7989,  0.8025,  0.8032,  0.8063,  0.8063,  0.8106,  0.8133,  0.8153};
float32 test_px[TEST_LENGTH] = {0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000, -0.4448, -0.4448, -0.4448, -0.4448,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.4448,  0.4448,  0.4448,  0.4448,  0.4448,  0.4448,  0.4448,  0.4448,  0.4448,  0.4448,  0.4448,  0.4448,  0.4448,  0.4448,  0.4448,  0.4448,  0.4448,  0.4448,  0.4448,  0.4448,  0.4448,  0.4448,  0.4448,  0.4448,  0.4448,  0.4448,  0.4448,  0.4448,  0.4448,  0.4448,  0.7784,  0.7784,  0.7784,  0.7784,  0.7784,  0.7784,  0.7784,  0.7784,  0.7784,  0.7784,  0.7784,  0.7784,  0.7784,  0.7784,  0.7784,  0.7784,  0.7784,  0.7784,  0.7784,  0.7784,  0.7784,  0.7784,  0.7784,  0.7784,  0.7784,  0.7784,  0.7784,  0.7784,  0.7784,  0.7784,  1.2231,  1.2231,  1.2231,  1.2231,  1.2231,  1.2231,  1.2231,  1.2231,  1.2231,  1.2231,  1.2231,  1.2231,  1.2231,  1.2231,  1.2231,  1.2231,  1.2231,  1.2231,  1.2231,  1.2231,  1.8903,  1.8903,  1.8903,  1.8903,  1.8903,  1.8903,  1.8903,  1.8903,  1.8903,  1.8903,  1.8903,  1.8903,  1.8903,  1.8903,  1.8903,  1.8903,  1.8903,  1.8903,  1.8903,  1.8903,  1.8903,  1.8903,  1.8903,  1.8903,  1.8903,  2.3351,  2.3351,  2.3351,  2.3351,  2.3351,  2.3351,  2.3351,  2.3351,  2.3351,  2.3351,  2.3351,  2.3351,  2.3351,  2.3351,  2.3351,  2.3351,  2.3351,  2.3351,  2.3351,  2.3351,  2.3351,  2.3351,  2.3351,  2.3351,  2.3351,  2.3351,  2.3351,  2.3351,  2.3351,  2.3351,  2.3351,  2.3351,  2.3351,  2.3351,  2.3351,  2.7799,  2.7799,  2.7799,  2.7799,  2.7799,  2.7799,  2.7799,  2.7799,  2.7799,  2.7799,  2.7799,  2.7799,  2.7799,  2.7799,  2.7799,  2.7799,  2.7799,  2.7799,  2.7799,  2.7799,  3.1135,  3.1135,  3.1135,  3.1135,  3.1135,  3.1135,  3.1135,  3.1135,  3.1135,  3.1135,  3.1135,  3.1135,  3.1135,  3.1135,  3.1135,  3.1135,  3.1135,  3.1135,  3.1135,  3.1135,  3.5582,  3.5582,  3.5582,  3.5582,  3.5582,  3.5582,  3.5582,  3.5582,  3.5582,  3.5582,  3.5582,  3.5582,  3.5582,  3.5582,  3.5582,  3.5582,  4.0030,  4.0030,  4.0030,  4.0030,  4.0030,  4.0030,  4.0030,  4.0030,  4.0030,  4.0030,  4.0030,  4.0030,  4.0030,  4.0030,  4.0030,  4.0030,  4.0030,  4.0030,  4.0030,  4.4478,  4.4478,  4.4478,  4.4478,  4.4478,  4.4478,  4.4478,  4.4478,  4.4478,  4.4478,  4.4478,  4.4478,  4.4478,  4.4478,  4.4478,  4.4478,  4.4478,  4.4478,  4.4478,  4.4478,  5.1150,  5.1150,  5.1150,  5.1150,  5.1150,  5.1150,  5.1150,  5.1150,  5.1150,  5.1150,  5.1150,  5.1150,  5.1150,  5.1150,  5.1150,  5.1150,  5.1150,  5.1150,  5.1150,  5.1150,  5.1150,  5.1150,  5.1150,  5.1150,  5.1150,  5.4486,  5.4486,  5.4486,  5.4486,  5.4486,  5.4486,  5.4486,  5.4486,  5.4486,  5.4486,  5.4486,  5.4486,  5.4486,  5.4486,  5.4486,  5.8933,  5.8933,  5.8933,  5.8933,  5.8933,  5.8933,  5.8933,  5.8933,  5.8933,  5.8933,  5.8933,  5.8933,  5.8933,  5.8933,  5.8933,  5.8933,  5.8933,  5.8933,  5.8933,  5.8933,  5.8933,  5.8933,  5.8933,  5.8933,  5.8933,  6.3381,  6.3381,  6.3381,  6.3381,  6.3381,  6.3381,  6.3381,  6.3381,  6.3381,  6.3381,  6.3381,  6.3381,  6.3381,  6.3381,  6.3381,  6.3381,  6.3381,  6.3381,  6.3381,  6.3381,  6.7829,  6.7829,  6.7829,  6.7829};
float32 test_py[TEST_LENGTH] = {0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  1.4500,  1.4500,  1.4500,  1.4500,  1.4500,  1.4500,  1.4500,  1.4500,  1.4500,  1.4500,  1.4500,  1.4500,  1.4500,  1.4500,  1.4500,  1.4500,  1.4500,  1.4500,  1.4500,  1.4500,  1.4500,  1.4500,  1.4500,  1.4500,  1.4500,  1.4500,  1.4500,  1.4500,  1.4500,  1.4500,  1.4500,  1.4500,  1.4500,  1.4500,  1.4500,  1.4500,  1.4500,  1.4500,  1.4500,  1.4500,  1.4500,  1.4500,  1.4500,  1.4500,  1.4500,  1.4500,  1.4500,  1.4500,  1.4500,  1.4500,  1.4500,  1.4500,  1.4500,  1.4500,  1.4500,  1.4500,  1.4500,  1.4500,  1.4500,  1.4500,  1.4500,  1.4500,  1.4500,  1.4500,  1.4500,  1.4500,  1.4500,  1.4500,  1.4500,  1.4500,  1.4500,  1.4500,  1.4500,  1.4500,  1.4500,  1.4500,  1.4500,  1.4500,  1.4500,  1.4500,  1.4500,  1.4500,  1.4500,  1.4500,  1.4500,  1.4500,  1.4500,  1.4500,  1.4500,  1.4500,  1.4500,  1.4500,  1.4500,  1.4500,  1.4500,  1.4500,  1.4500,  1.4500,  1.4500,  1.4500,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  2.9000,  4.4467,  4.4467,  4.4467,  4.4467,  4.4467,  4.4467,  4.4467,  4.4467,  4.4467,  4.4467,  4.4467,  4.4467,  4.4467,  4.4467,  4.4467,  4.4467,  4.4467,  4.4467,  4.4467};
float32 test_pz[TEST_LENGTH] = {-0.1755,  0.2085, -0.0444, -0.0597,  0.1110, -0.1024,  0.2024, -0.3157, -0.2578, -0.0262, -0.0079,  0.1872, -0.0475, -0.2395,  0.2817, -0.0292,  0.0470,  0.0683,  0.1628, -0.0688,  0.2604,  0.1415,  0.1994, -0.1298,  0.0440, -0.2669, -0.2456,  0.2146,  0.0043, -0.0536, -0.0353, -0.0170, -0.1328, -0.1755, -0.1206, -0.1176,  0.2482,  0.0348, -0.3706, -0.1420,  0.0714, -0.0048,  0.1080,  0.2238,  0.0287,  0.0866,  0.4554, -0.1054, -0.0109, -0.0871,  0.0257, -0.1846,  0.0653, -0.2426,  0.5865, -0.0109,  0.3731, -0.3035,  0.4890,  0.1019,  0.0043,  0.0043, -0.1877,  0.1384, -0.1511, -0.0932,  0.1171, -0.0932,  0.1019,  0.0043, -0.2456, -0.2273,  0.0226, -0.0353,  0.0805,  0.0440, -0.0353,  0.0043,  0.1415, -0.1298,  0.5255, -0.0322, -0.2456, -0.0140, -0.0109,  0.3152, -0.2822,  0.2177, -0.0932, -0.5931, -0.2243, -0.1877,  0.1781, -0.1084, -0.1877,  0.1232, -0.0719,  0.1019,  0.0653,  0.0653, -0.1115, -0.1084, -0.0109, -0.3980, -0.2669, -0.0109, -0.0719,  0.0866,  0.2390,  0.1994,  0.0287, -0.1846,  0.0104, -0.0475, -0.1633,  0.3000,  0.2024,  0.0683, -0.0871, -0.0475,  0.1262,  0.2451, -0.5656, -0.1206,  0.2482,  0.0318,  0.2268,  0.2482,  0.0348, -0.2548, -0.4285, -0.5992, -0.0993, -0.0597, -0.0810, -0.2730, -0.1755, -0.4834, -0.4285, -0.3706, -0.1968, -0.2151, -0.4468, -0.3889, -0.4681, -0.3919, -0.6601, -0.6998, -0.8339, -0.5047, -0.4681, -1.0472, -0.8339, -0.7790, -0.6632, -0.5077, -0.6083, -0.8156, -0.8369, -0.6449, -0.8186, -0.8796, -1.0137, -0.8400, -0.6266, -0.9924, -1.0716, -0.6083, -0.8400, -0.9588, -0.8796, -0.6479, -0.9771, -0.7241, -1.1295, -1.3246, -0.9009, -1.0899, -0.7638, -0.6845, -1.1844, -1.0869, -1.3429, -1.1265, -1.0137, -1.1082, -1.0686, -0.8948, -1.1234, -0.9497, -1.0472, -1.0869, -1.6446, -1.2789, -0.6388, -1.1783, -1.3124, -1.2362, -0.7333, -1.1570, -1.1935, -0.9619, -1.2880, -1.1143, -1.2301, -1.2514, -0.9406, -1.1905, -0.9192, -0.8034, -0.7089, -1.1905, -0.9192, -1.1874, -1.0747, -1.0350, -1.1509, -0.8613, -1.2240, -1.0503, -0.9345, -0.8186, -0.6998, -0.8735, -0.8552, -1.1844, -1.4343, -0.9893, -1.1783, -1.1417, -0.6784, -1.1600, -0.9680, -0.7699, -1.0990, -1.0015, -1.1173, -1.1356, -1.0015, -0.8278, -1.1752, -0.9040, -1.0015, -1.2880, -1.3856, -0.8644, -0.5900, -0.9771, -0.9954, -1.0168, -0.7241, -1.3063, -0.7821, -1.2240, -1.1082, -0.8003, -1.2454, -0.9741, -0.8613, -0.5504, -1.0137, -0.7424, -0.9924, -1.1295, -1.1295, -1.4953, -1.1082, -0.7821, -0.8948, -1.3216, -0.8583, -0.9924, -1.1082, -1.0869, -1.3398, -1.0686, -1.1082, -1.1265, -1.4130, -1.0076, -1.1265, -0.9131, -1.2606, -1.0107, -1.7239, -1.1631, -1.0503, -1.1844, -1.1813, -1.0076, -1.3368, -1.1813, -1.2393, -1.1051, -1.0472, -1.2393, -1.2972, -0.9680, -0.9893, -0.9680, -0.8918, -1.2789, -1.1234, -1.0655, -0.8522, -0.6784, -1.2575, -1.4130, -1.1966, -1.2575, -1.1966, -1.3155, -1.1387, -1.4679, -1.0015, -1.0259, -0.9649, -0.8887, -1.0625, -1.2911, -1.4099, -0.7302, -1.0015, -1.4252, -0.9040, -1.0015, -0.8095, -1.2149, -1.0808, -1.4648, -1.0564, -1.3673, -1.0990, -1.2118, -1.2118, -0.9040, -1.0381, -1.0015, -1.2332, -1.0381, -1.0777, -1.1752, -1.2911, -1.4831, -1.0411, -1.0960, -1.1173, -0.9253, -1.1935, -0.8644, -0.5992, -1.5410, -1.0777, -1.1173, -1.3276, -1.2118, -0.7302, -1.0990, -1.2514, -1.1935, -1.0015, -0.8491, -1.1935, -1.3673, -1.2514, -0.9436, -1.1570, -1.1570, -1.6568, -1.1387, -0.9436, -1.2514, -1.3124, -1.1173, -1.2149, -1.1204, -1.3520, -0.7912, -1.3124, -1.3124, -1.2362, -1.1600, -1.1783, -0.9863, -1.0838, -1.0625, -0.8887, -1.1387, -1.5075, -0.7912, -1.1600, -0.7912, -1.2758, -0.9649, -1.5623, -1.5441, -0.9284, -1.3337, -1.2941, -1.1387, -0.9466, -1.4496, -1.3917, -1.0838, -1.0838, -1.3520, -1.5654, -1.2545, -1.1173, -1.0808, -1.0777, -1.2149, -1.1600, -0.9619, -0.8491, -1.2728, -0.9040, -1.3490, -1.3490, -1.3673, -1.1173, -1.2149, -1.0015, -1.3673, -1.3307, -1.0228, -0.7516, -1.7544, -0.7729, -1.5623, -1.1387, -1.4861, -1.4465, -1.3094, -1.0990, -1.4496, -1.3307, -1.2728, -1.4648, -0.7882, -1.1722, -1.1539, -0.9253, -1.3642, -1.0777, -1.2118, -1.0930, -1.1752, -1.1905, -1.3276, -1.2118, -1.0168, -1.3063, -1.3429, -1.0930, -1.0564, -1.0930, -1.2271, -1.0564, -1.1722, -0.9985, -1.0930, -1.2301, -1.3246, -1.0930, -1.4008, -1.2118, -0.9771, -1.2850, -1.2088, -1.0350, -1.5349, -0.8400, -1.0350, -0.9588, -1.3033, -1.5014, -1.5166, -1.1112, -0.6876, -1.1874, -1.0930, -1.2454, -1.2088, -1.1326, -1.6324, -1.6904, -1.3795, -1.5166, -1.2667, -1.4191, -1.2454, -1.2240, -1.1905, -0.9192, -1.0137, -1.0716, -1.0137, -1.1874, -1.2454};
float32 test_vx[TEST_LENGTH] = {0.0100,  0.0200,  0.0200,  0.0200,  0.0200,  0.0200,  0.0100,  0.0100,  0.0100,  0.0100,  0.0100,  0.0500,  0.0500,  0.0500,  0.0500,  0.0500,  0.0100,  0.0100,  0.0100,  0.0100,  0.0100,  0.0100,  0.0500,  0.0500,  0.0500,  0.0500,  0.0100,  0.0100,  0.0100,  0.0100,  0.0100,  0.0400,  0.0400,  0.0400,  0.0400,  0.0400,  0.0500,  0.0500,  0.0500,  0.0500,  0.0500,  0.0600,  0.0600,  0.0600,  0.0600,  0.0600,  0.0600,  0.0600,  0.0600,  0.0600,  0.0600,  0.0300,  0.0300,  0.0300,  0.0300,  0.0300,  0.0500,  0.0500,  0.0500,  0.0500,  0.0500,  0.0500,  0.0500,  0.0500,  0.0500,  0.0500,  0.0300,  0.0300,  0.0300,  0.0300,  0.0300,  0.0300,  0.0800,  0.0800,  0.0800,  0.0800,  0.0100,  0.0100,  0.0100,  0.0100,  0.0100,  0.0100,  0.0100,  0.0100,  0.0100,  0.0100,  0.0800,  0.0800,  0.0800,  0.0800,  0.0800,  0.0400,  0.0400,  0.0400,  0.0400,  0.0400,  0.0500,  0.0500,  0.0500,  0.0500,  0.0500,  0.0100,  0.0100,  0.0100,  0.0100,  0.0100,  0.0100,  0.0100,  0.0100,  0.0100,  0.0100,  0.0200,  0.0200,  0.0200,  0.0200,  0.0200,  0.0200,  0.0200,  0.0200,  0.0200,  0.0200,  0.0200,  0.0500,  0.0500,  0.0500,  0.0500,  0.1100,  0.1100,  0.1100,  0.1100,  0.1100, -0.0778, -0.0778, -0.0778, -0.0778, -0.0778,  0.2400,  0.2400,  0.2400,  0.2400,  0.2400,  0.2938,  0.2938,  0.2938,  0.2938,  0.2938,  0.4096,  0.4096,  0.4096,  0.4096,  0.4096,  0.5489,  0.5489,  0.5489,  0.5489,  0.5489,  0.5721,  0.5721,  0.5721,  0.5721,  0.5721,  0.5109,  0.5109,  0.5109,  0.5109,  0.5109,  0.4030,  0.4030,  0.4030,  0.4030,  0.4030,  0.4030,  0.5880,  0.5880,  0.5880,  0.5880,  0.7040,  0.7040,  0.7040,  0.7040,  0.7040,  0.4704,  0.4704,  0.4704,  0.4704,  0.4704,  0.6842,  0.6842,  0.6842,  0.6842,  0.6842,  0.4577,  0.4577,  0.4577,  0.4577,  0.4577,  0.5657,  0.5657,  0.5657,  0.5657,  0.5657,  0.6247,  0.6247,  0.6247,  0.6247,  0.6247,  0.9286,  0.9286,  0.9286,  0.9286,  0.9286,  0.6933,  0.6933,  0.6933,  0.6933,  0.6933,  0.9197,  0.9197,  0.9197,  0.9197,  0.9197,  0.9197,  0.8417,  0.8417,  0.8417,  0.8417,  0.9006,  0.9006,  0.9006,  0.9006,  0.9006,  0.9262,  0.9262,  0.9262,  0.9262,  0.9262,  0.8359,  0.8359,  0.8359,  0.8359,  0.8359,  1.0316,  1.0316,  1.0316,  1.0316,  1.0316,  1.1559,  1.1559,  1.1559,  1.1559,  1.1559,  0.7710,  0.7710,  0.7710,  0.7710,  0.7710,  1.0181,  1.0181,  1.0181,  1.0181,  1.0181,  0.8098,  0.8098,  0.8098,  0.8098,  0.8098,  0.6986,  0.6986,  0.6986,  0.6986,  0.6986,  0.6986,  1.0909,  1.0909,  1.0909,  1.0909,  0.8616,  0.8616,  0.8616,  0.8616,  0.8616,  0.7625,  0.7625,  0.7625,  0.7625,  0.7625,  0.7620,  0.7620,  0.7620,  0.7620,  0.7620,  0.7659,  0.7659,  0.7659,  0.7659,  0.7659,  0.7006,  0.7006,  0.7006,  0.7006,  0.7006,  0.8792,  0.8792,  0.8792,  0.8792,  0.8792,  0.7200,  0.7200,  0.7200,  0.7200,  0.7200,  0.5791,  0.5791,  0.5791,  0.5791,  0.5791,  0.7803,  0.7803,  0.7803,  0.7803,  0.7803,  0.7803,  0.6690,  0.6690,  0.6690,  0.6690,  0.6741,  0.6741,  0.6741,  0.6741,  0.6741,  0.9767,  0.9767,  0.9767,  0.9767,  0.9767,  1.0631,  1.0631,  1.0631,  1.0631,  1.0631,  0.9526,  0.9526,  0.9526,  0.9526,  0.9526,  0.8560,  0.8560,  0.8560,  0.8560,  0.8560,  0.8958,  0.8958,  0.8958,  0.8958,  0.8958,  0.9698,  0.9698,  0.9698,  0.9698,  0.9698,  0.9384,  0.9384,  0.9384,  0.9384,  0.9384,  1.2419,  1.2419,  1.2419,  1.2419,  1.2419,  1.2419,  1.1393,  1.1393,  1.1393,  1.1393,  1.1041,  1.1041,  1.1041,  1.1041,  1.1041,  1.0464,  1.0464,  1.0464,  1.0464,  1.0464,  0.9821,  0.9821,  0.9821,  0.9821,  0.9821,  1.0564,  1.0564,  1.0564,  1.0564,  1.0564,  1.0378,  1.0378,  1.0378,  1.0378,  1.0378,  1.0699,  1.0699,  1.0699,  1.0699,  1.0699,  0.9489,  0.9489,  0.9489,  0.9489,  0.9489,  0.8333,  0.8333,  0.8333,  0.8333,  0.8333,  1.0009,  1.0009,  1.0009,  1.0009,  1.0009,  1.0009,  1.0790,  1.0790,  1.0790,  1.0790,  1.0221,  1.0221,  1.0221,  1.0221,  1.0221,  0.9821,  0.9821,  0.9821,  0.9821,  0.9821,  0.9722,  0.9722,  0.9722,  0.9722,  0.9722,  1.0721,  1.0721,  1.0721,  1.0721,  1.0721,  1.0908,  1.0908,  1.0908,  1.0908,  1.0908,  1.1695,  1.1695,  1.1695,  1.1695,  1.1695,  1.1216,  1.1216,  1.1216,  1.1216,  1.1216,  0.7196,  0.7196,  0.7196,  0.7196,  0.7196,  0.9451,  0.9451,  0.9451,  0.9451,  0.9451,  1.1680,  1.1680,  1.1680,  1.1680,  1.1680,  1.1509,  1.1509,  1.1509,  1.1509,  1.1509,  1.1236,  1.1236,  1.1236,  1.1236,  1.1236,  1.1493,  1.1493,  1.1493,  1.1493,  1.1493,  1.1218,  1.1218,  1.1218,  1.1218,  1.1218,  1.0893,  1.0893,  1.0893,  1.0893};
float32 test_vy[TEST_LENGTH] = {0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000, -0.2585, -0.2585, -0.2585, -0.2585, -0.2585,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000, -0.2249, -0.2249, -0.2249, -0.2249, -0.2249, -0.0930, -0.0930, -0.0930, -0.0930, -0.0930, -0.1538, -0.1538, -0.1538, -0.1538, -0.1538, -0.3857, -0.3857, -0.3857, -0.3857, -0.3857, -0.2746, -0.2746, -0.2746, -0.2746, -0.2746, -0.2218, -0.2218, -0.2218, -0.2218, -0.2218, -0.2218, -0.0490, -0.0490, -0.0490, -0.0490,  0.0920,  0.0920,  0.0920,  0.0920,  0.0920,  0.0954,  0.0954,  0.0954,  0.0954,  0.0954,  0.0894,  0.0894,  0.0894,  0.0894,  0.0894,  0.0459,  0.0459,  0.0459,  0.0459,  0.0459,  0.2001,  0.2001,  0.2001,  0.2001,  0.2001,  0.2423,  0.2423,  0.2423,  0.2423,  0.2423,  0.5317,  0.5317,  0.5317,  0.5317,  0.5317,  0.4743,  0.4743,  0.4743,  0.4743,  0.4743,  0.6566,  0.6566,  0.6566,  0.6566,  0.6566,  0.6566,  0.3460,  0.3460,  0.3460,  0.3460,  0.5398,  0.5398,  0.5398,  0.5398,  0.5398,  0.6473,  0.6473,  0.6473,  0.6473,  0.6473,  0.6354,  0.6354,  0.6354,  0.6354,  0.6354,  0.6325,  0.6325,  0.6325,  0.6325,  0.6325,  0.5727,  0.5727,  0.5727,  0.5727,  0.5727,  0.4834,  0.4834,  0.4834,  0.4834,  0.4834,  0.7423,  0.7423,  0.7423,  0.7423,  0.7423,  0.6684,  0.6684,  0.6684,  0.6684,  0.6684,  0.8625,  0.8625,  0.8625,  0.8625,  0.8625,  0.8625,  0.8122,  0.8122,  0.8122,  0.8122,  0.5645,  0.5645,  0.5645,  0.5645,  0.5645,  0.4781,  0.4781,  0.4781,  0.4781,  0.4781,  0.6162,  0.6162,  0.6162,  0.6162,  0.6162,  0.6584,  0.6584,  0.6584,  0.6584,  0.6584,  0.5326,  0.5326,  0.5326,  0.5326,  0.5326,  0.7257,  0.7257,  0.7257,  0.7257,  0.7257,  0.8709,  0.8709,  0.8709,  0.8709,  0.8709,  0.7149,  0.7149,  0.7149,  0.7149,  0.7149,  0.8034,  0.8034,  0.8034,  0.8034,  0.8034,  0.8034,  0.8606,  0.8606,  0.8606,  0.8606,  0.6407,  0.6407,  0.6407,  0.6407,  0.6407,  0.6972,  0.6972,  0.6972,  0.6972,  0.6972,  0.8955,  0.8955,  0.8955,  0.8955,  0.8955,  0.8698,  0.8698,  0.8698,  0.8698,  0.8698,  1.0568,  1.0568,  1.0568,  1.0568,  1.0568,  0.8861,  0.8861,  0.8861,  0.8861,  0.8861,  0.8506,  0.8506,  0.8506,  0.8506,  0.8506,  0.9283,  0.9283,  0.9283,  0.9283,  0.9283,  0.9441,  0.9441,  0.9441,  0.9441,  0.9441,  0.9441,  0.7963,  0.7963,  0.7963,  0.7963,  0.7234,  0.7234,  0.7234,  0.7234,  0.7234,  0.6272,  0.6272,  0.6272,  0.6272,  0.6272,  0.6719,  0.6719,  0.6719,  0.6719,  0.6719,  0.7227,  0.7227,  0.7227,  0.7227,  0.7227,  0.5403,  0.5403,  0.5403,  0.5403,  0.5403,  0.6269,  0.6269,  0.6269,  0.6269,  0.6269,  0.5949,  0.5949,  0.5949,  0.5949,  0.5949,  0.4129,  0.4129,  0.4129,  0.4129,  0.4129,  0.5864,  0.5864,  0.5864,  0.5864,  0.5864,  0.5864,  0.7070,  0.7070,  0.7070,  0.7070,  0.6843,  0.6843,  0.6843,  0.6843,  0.6843,  0.6719,  0.6719,  0.6719,  0.6719,  0.6719,  0.6509,  0.6509,  0.6509,  0.6509,  0.6509,  0.6427,  0.6427,  0.6427,  0.6427,  0.6427,  0.7953,  0.7953,  0.7953,  0.7953,  0.7953,  0.6542,  0.6542,  0.6542,  0.6542,  0.6542,  0.6572,  0.6572,  0.6572,  0.6572,  0.6572,  0.3931,  0.3931,  0.3931,  0.3931,  0.3931,  0.4801,  0.4801,  0.4801,  0.4801,  0.4801,  0.7161,  0.7161,  0.7161,  0.7161,  0.7161,  0.7056,  0.7056,  0.7056,  0.7056,  0.7056,  0.6735,  0.6735,  0.6735,  0.6735,  0.6735,  0.6889,  0.6889,  0.6889,  0.6889,  0.6889,  0.7511,  0.7511,  0.7511,  0.7511,  0.7511,  0.6530,  0.6530,  0.6530,  0.6530};

extern float32 AHRS_states[AHRS_N_STATES];
extern float32 INS_states[INS_N_STATES];

void test_filter(){
	init_AHRS(test_AHRS_x0[0], test_AHRS_x0[1], test_AHRS_x0[2], test_AHRS_x0[3], test_AHRS_x0[4], test_AHRS_x0[5], test_AHRS_x0[6]);
	init_INS(test_INS_x0[0], test_INS_x0[1], test_INS_x0[2], test_INS_x0[3], test_INS_x0[4], test_INS_x0[5], test_INS_x0[6], test_INS_x0[8], test_INS_x0[8]);

	int i;
	for(i=0;i<TEST_LENGTH;i++){
		update_INS_u(-test_ax[i]*GRAVITY, -test_ay[i]*GRAVITY, -test_az[i]*GRAVITY);
		update_INS_z(test_px[i], test_py[i], test_pz[i], test_vx[i], test_vy[i]);
		INS_step();

		update_AHRS_u(test_wx[i], test_wy[i], test_wz[i]);
		update_AHRS_z(test_ax[i], test_ay[i], test_az[i], test_mag_x[i], test_mag_y[i], test_mag_z[i]);
		AHRS_step();
		AHRS_normalize_q();

//		sci_printf("%7.4f,%7.4f,%7.4f,%7.4f,%7.4f,%7.4f,%7.4f,%7.4f,%7.4f,%7.4f,%7.4f,%7.4f,%7.4f,%7.4f\r\n", test_wx[i], test_wy[i], test_wz[i], test_ax[i], test_ay[i], test_az[i], test_mag_x[i], test_mag_y[i], test_mag_z[i], test_px[i], test_py[i], test_pz[i], test_vx[i], test_vy[i]);
		sci_printf("%7.4f,%7.4f,%7.4f,%7.4f,%7.4f,%7.4f,%7.4f,",AHRS_states[0], AHRS_states[1], AHRS_states[2], AHRS_states[3], AHRS_states[4], AHRS_states[5], AHRS_states[6]);
		sci_printf("%7.4f,%7.4f,%7.4f,%7.4f,%7.4f,%7.4f,%7.4f,%7.4f,%7.4f\r\n",	INS_states[0], INS_states[1], INS_states[2], INS_states[3], INS_states[4], INS_states[5], INS_states[6], INS_states[7], INS_states[8]);
	}

	while(1);
}
